﻿using System;
using System.Linq;
using Verse;
using RimWorld;
using AdditionalVerb;
using UnityEngine;

namespace yayoShooting
{

	[StaticConstructorOnStartup]
	public static class VerbChanger {


		static VerbChanger()
		{
			//Ammunition.Utility.Utility.Fire();
			foreach (ThingDef t in from thing in DefDatabase<ThingDef>.AllDefs where thing.Verbs != null select thing)
			{

				if (t.thingCategories != null &&
					t.thingCategories.Count > 0 &&
					t.IsRangedWeapon &&
					t.Verbs.Count <= 1 &&
					t.Verbs[0].verbClass != typeof(Verb_ShootOneUse) &&
					t.Verbs[0].verbClass != typeof(Verb_LaunchProjectile) &&
					!t.Verbs[0].targetParams.canTargetLocations
					)
				{
					

					t.comps.Add(new CompProperties(typeof(Comp_VerbSaveable)));

					VerbProperties baseProp = t.Verbs[0];

					VerbProperties_Custom2 prop;
					float accuracyAdjust = 1;


					// 기본사격

					prop = new VerbProperties_Custom2();
					prop.isPrimary = true;
					prop.verbClass = baseProp.verbClass;
					prop.hasStandardCommand = baseProp.hasStandardCommand;
					prop.defaultProjectile = baseProp.defaultProjectile;
					prop.forcedMissRadius = baseProp.forcedMissRadius;
					prop.warmupTime = baseProp.warmupTime;
					prop.range = baseProp.range;
					prop.burstShotCount = baseProp.burstShotCount;
					prop.ticksBetweenBurstShots = baseProp.ticksBetweenBurstShots;
					prop.soundCast = baseProp.soundCast;
					prop.soundCastTail = baseProp.soundCastTail;
					prop.muzzleFlashScale = baseProp.muzzleFlashScale;
					prop.label = "yayoShooting_basicshot_label".Translate();
					prop.desc = "yayoShooting_basicshot_desc".Translate();
					prop.texPath = "UI/Commands/basic";

					prop.accuracyTouch = t.GetStatValueAbstract(StatDefOf.AccuracyTouch);
					prop.accuracyShort = t.GetStatValueAbstract(StatDefOf.AccuracyShort);
					prop.accuracyMedium = t.GetStatValueAbstract(StatDefOf.AccuracyMedium);
					prop.accuracyLong = t.GetStatValueAbstract(StatDefOf.AccuracyLong);

					t.Verbs.Add(prop);







					// 정밀사격

					prop = new VerbProperties_Custom2();
					prop.verbClass = baseProp.verbClass;
					prop.hasStandardCommand = baseProp.hasStandardCommand;
					prop.defaultProjectile = baseProp.defaultProjectile;
					prop.forcedMissRadius = baseProp.forcedMissRadius * 0.7f;
					prop.warmupTime = baseProp.warmupTime * 1.3f;

					bool isSniperRifle = t.weaponTags != null && t.weaponTags.Contains("SniperRifle");

					if (isSniperRifle)
					{
						prop.range = baseProp.range;
					}
					else
					{
						prop.range = baseProp.range + Mathf.Clamp((baseProp.range * 0.3f), 0f, 6f);
					}

					prop.burstShotCount = baseProp.burstShotCount;

					prop.ticksBetweenBurstShots = baseProp.ticksBetweenBurstShots;

					prop.soundCast = baseProp.soundCast;
					prop.soundCastTail = baseProp.soundCastTail;
					prop.muzzleFlashScale = baseProp.muzzleFlashScale;

					prop.label = "yayoShooting_aimshot_label".Translate();
					prop.desc = "yayoShooting_aimshot_desc".Translate();
					prop.texPath = "UI/Commands/aimShot";

					accuracyAdjust = 1.3f;



					prop.accuracyTouch = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyTouch), accuracyAdjust);
					prop.accuracyShort = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyShort), accuracyAdjust);
					prop.accuracyMedium = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyMedium), accuracyAdjust);
					prop.accuracyLong = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyLong), accuracyAdjust);

					

					t.Verbs.Add(prop);

					//


					// 제압사격

					prop = new VerbProperties_Custom2();

					prop.ammoUse = 3;

					prop.verbClass = baseProp.verbClass;
					prop.hasStandardCommand = baseProp.hasStandardCommand;
					prop.defaultProjectile = baseProp.defaultProjectile;
					prop.forcedMissRadius = baseProp.forcedMissRadius * 1.2f + 6f;
					prop.warmupTime = baseProp.warmupTime;
					prop.range = baseProp.range;

					prop.burstShotCount = baseProp.burstShotCount * 3;

					if(baseProp.ticksBetweenBurstShots == null)
					{
						prop.ticksBetweenBurstShots = 9;
					}
					else
					{
						int tmp = Mathf.RoundToInt((float)baseProp.ticksBetweenBurstShots * 0.4f);
						prop.ticksBetweenBurstShots = tmp > 0 ? tmp : 1;
					}
					
					prop.soundCast = baseProp.soundCast;
					prop.soundCastTail = baseProp.soundCastTail;
					prop.muzzleFlashScale = baseProp.muzzleFlashScale;

					prop.label = "yayoShooting_burst_label".Translate();
					prop.desc = "yayoShooting_burst_desc".Translate();
					prop.texPath = "UI/Commands/burst";

					accuracyAdjust = 0.13f;

					prop.accuracyTouch = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyTouch), accuracyAdjust);
					prop.accuracyShort = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyShort), accuracyAdjust);
					prop.accuracyMedium = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyMedium), accuracyAdjust);
					prop.accuracyLong = adjustAccuracy(t.GetStatValueAbstract(StatDefOf.AccuracyLong), accuracyAdjust);

					prop.targetParams.canTargetLocations = true;
					

					t.Verbs.Add(prop);




					// 셀렉터

					//VerbProperties prop_s = t.Verbs[0];
					//prop_s.verbClass = typeof(Verb_Shoot_Selected);

					//t.Verbs[0] = prop_s;
					t.Verbs[0].verbClass = typeof(Verb_Shoot_Selected);
					t.Verbs[0].isPrimary = false;



				}
				

				
			}
		}


		static float adjustAccuracy(float accuracy, float adjust)
		{
			float tmp = accuracy;

			/*
			if(adjust > 1f)
			{
				if(tmp > 1f)
				{
					tmp = 1f + (tmp - 1f) * adjust;
				}
				else
				{
					tmp = 1f - (1f - tmp) / adjust;
				}
				
			}
			else
			{
				tmp *= adjust;
			}
			*/

			tmp *= adjust;
			if(tmp > 1f)
			{
				tmp = 1f;
			}

			return tmp;
		}

	}


	





}